/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.cf3270em;

import com.ibm.hwmca.base.cf3270em.Cf3270EmConstants;
import com.ibm.hwmca.base.cf3270em.Cf3270EmErrorIds;
import com.ibm.hwmca.base.cf3270em.Cf3270EmTask;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Iterator;
import java.util.TreeMap;

public class EmulatorSessionsBean
extends PanelBean
implements Cf3270EmErrorIds,
Cf3270EmConstants {
    private static final String TRACE_MASKT = "XEMU   T";
    private static final String TRACE_MASKF = "XEMU   F";
    private static final String TRACE_MASKD = "XEMU   D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-93, "EmulatorSessionsBean");
    private static final String CF3270EM_HOSTERROR_TITLE = "cf3270em.hosterror.title";
    private static final String CF3270EM_HOSTERROR_TEXT = "cf3270em.hosterror.text";
    private static final String CF3270EM_DUPLICATE_TITLE = "cf3270em.duplicate.title";
    private static final String CF3270EM_DUPLICATE_TEXT = "cf3270em.duplicate.text";
    private static final String CF3270EM_NO_SELECTION_TITLE = "cf3270em.noselection.title";
    private static final String CF3270EM_NO_SELECTION_TEXT = "cf3270em.noselection.text";
    private static final String CF3270EM_HOSTERROR1_TITLE = "cf3270em.hosterror1.title";
    private static final String CF3270EM_HOSTERROR1_TEXT = "cf3270em.hosterror1.text";
    private static final String CF3270EM_NOT_FIXED_TITLE = "cf3270em.notfixed.title";
    private static final String CF3270EM_NOT_FIXED_TEXT = "cf3270em.notfixed.text";
    private TreeMap origHosts = new TreeMap();
    private TreeMap newHosts = new TreeMap();
    private String enabled;
    private String disabled;
    private boolean verifyHost;
    private boolean ipHostError;
    private String badIpAddr;
    private int badRow;
    private int rowWithError;
    private boolean showMsg;
    private ItemDescriptor[][] m_idSessionsTable;
    private ColumnDescriptor[] m_cdSessionsTableStructure;
    private int[] m_iSessionsTableSelection;

    public void setOrigSettings(TreeMap hosts, String enabled, String disabled) {
        this.enabled = enabled;
        this.disabled = disabled;
        Iterator it = hosts.keySet().iterator();
        while (it.hasNext()) {
            String hostAddr = new String((String)it.next());
            Boolean boolVal = (Boolean)hosts.get(hostAddr);
            this.origHosts.put(hostAddr, boolVal);
            this.newHosts.put(hostAddr, boolVal);
        }
    }

    public void setSessionsTableSelection(int[] selected) throws IllegalUserDataException {
        if (this.m_iSessionsTableSelection.length > 0) {
            if (this.m_iSessionsTableSelection[0] != selected[0]) {
                int choice = this.m_iSessionsTableSelection[0];
                this.userTaskManager.setEnabled("Host" + choice, false);
                this.userTaskManager.setEnabled("Enable" + choice, false);
                this.m_iSessionsTableSelection = selected;
                choice = selected[0];
                this.userTaskManager.setEnabled("Host" + choice, true);
                this.userTaskManager.setEnabled("Enable" + choice, true);
                this.userTaskManager.refreshElement("SessionsTable");
            }
        } else {
            this.m_iSessionsTableSelection = selected;
            int choice = selected[0];
            this.userTaskManager.setEnabled("Host" + choice, true);
            this.userTaskManager.setEnabled("Enable" + choice, true);
            this.userTaskManager.refreshElement("SessionsTable");
        }
        this.badRow = -1;
    }

    public int[] getSessionsTableSelection() {
        return this.m_iSessionsTableSelection;
    }

    public void setSessionsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        if (this.ipHostError && index != this.rowWithError) {
            try {
                CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle(CF3270EM_NOT_FIXED_TITLE), new BaseMessageText(CF3270EM_NOT_FIXED_TEXT));
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKF, e);
            }
            this.setSessionsTableSelection(new int[]{this.rowWithError});
            this.badRow = this.rowWithError;
        } else {
            if (this.verifyHost) {
                String ipAddr = items[0].toString();
                this.newHosts.remove(this.m_idSessionsTable[index][0].toString());
                if (items[1].toString().equals(this.enabled)) {
                    this.newHosts.put(ipAddr, new Boolean(true));
                } else {
                    this.newHosts.put(ipAddr, new Boolean(false));
                }
                this.ipHostError = false;
                this.showMsg = false;
                if (!Cf3270EmTask.validIp(ipAddr)) {
                    try {
                        CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle(CF3270EM_HOSTERROR_TITLE), new BaseMessageText(CF3270EM_HOSTERROR_TEXT));
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, e);
                    }
                    int curSelection = this.m_iSessionsTableSelection[0];
                    this.setSessionsTableSelection(new int[]{index});
                    this.userTaskManager.refreshElement("SessionsTable");
                    this.ipHostError = true;
                    this.badIpAddr = ipAddr;
                    this.badRow = curSelection;
                    this.rowWithError = index;
                }
            }
            this.m_idSessionsTable[index] = items;
        }
    }

    public ItemDescriptor[] getSessionsTableRowAt(int index) {
        return this.m_idSessionsTable[index];
    }

    public int getSessionsTableRowCount() {
        return this.m_idSessionsTable.length;
    }

    public int getSessionsTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getSessionsTableRowStructure() {
        return this.m_cdSessionsTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.m_idSessionsTable = new ItemDescriptor[0][0];
        this.m_cdSessionsTableStructure = new ColumnDescriptor[0];
        this.m_iSessionsTableSelection = new int[0];
    }

    public void prepare() {
        this.verifyHost = false;
        this.m_idSessionsTable = new ItemDescriptor[this.newHosts.size()][2];
        this.m_iSessionsTableSelection = new int[0];
        int i = 0;
        Iterator it = this.newHosts.keySet().iterator();
        while (it.hasNext()) {
            ItemDescriptor[] id = new ItemDescriptor[2];
            String hostVal = (String)it.next();
            Boolean boolVal = (Boolean)this.newHosts.get(hostVal);
            id[0] = new ItemDescriptor("Host" + String.valueOf(i), hostVal);
            id[1] = new ItemDescriptor("Enable" + String.valueOf(i), boolVal != false ? this.enabled : this.disabled);
            this.setSessionsTableRowAt(i, id);
            ++i;
        }
        this.userTaskManager.refreshElement("SessionsTable");
        for (i = 0; i < this.newHosts.size(); ++i) {
            this.userTaskManager.setEnabled("Host" + String.valueOf(i), false);
            this.userTaskManager.setEnabled("Enable" + String.valueOf(i), false);
        }
        if (this.ipHostError) {
            i = 0;
            it = this.newHosts.keySet().iterator();
            while (it.hasNext()) {
                if (this.badIpAddr.equals((String)it.next())) {
                    this.userTaskManager.setEnabled("Host" + i, true);
                    this.userTaskManager.setEnabled("Enable" + i, true);
                    this.setSessionsTableSelection(new int[]{i});
                }
                ++i;
            }
        }
        this.userTaskManager.refreshElement("SessionsTable");
        this.verifyHost = true;
    }

    public void update(Object obj) {
        String[] newData = (String[])obj;
        if (this.newHosts.containsKey(newData[0])) {
            try {
                CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle(CF3270EM_DUPLICATE_TITLE), new BaseMessageText(CF3270EM_DUPLICATE_TEXT));
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKF, e);
            }
        } else {
            if (newData[1].equals(this.enabled)) {
                this.newHosts.put(newData[0], new Boolean(true));
            } else {
                this.newHosts.put(newData[0], new Boolean(false));
            }
            this.prepare();
        }
        int i = 0;
        Iterator it = this.newHosts.keySet().iterator();
        while (it.hasNext()) {
            if (newData[0].equals((String)it.next())) {
                this.userTaskManager.setEnabled("Host" + i, true);
                this.userTaskManager.setEnabled("Enable" + i, true);
                this.setSessionsTableSelection(new int[]{i});
            }
            ++i;
        }
        this.userTaskManager.refreshElement("SessionsTable");
    }

    public void save() {
    }

    /*
     * Unable to fully structure code
     */
    public void panelAction(TaskActionEvent event) {
        Trace.trace("XEMU   T", "[EmulatorSessionsBean] --> actionPerformed(" + event + ")");
        element = event.getElementName();
        if (!this.ipHostError || element.equals("CancelButton")) {
            panelNumber = "1";
            this.userTaskManager.storeAllElements();
            request = new PanelTaskletRequest();
            request.setData("Panel", panelNumber);
            request.setData("Event", event);
            Trace.trace("XEMU   T", "[EmulatorSessionsBean] element = " + element);
            try {
                if (element.equals("OkButton")) {
                    i = 0;
                    it = this.newHosts.keySet().iterator();
                    while (it.hasNext()) {
                        ckIpAddr = (String)it.next();
                        if (!Cf3270EmTask.validIp(ckIpAddr)) {
                            CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle("cf3270em.hosterror1.title"), new BaseMessageText("cf3270em.hosterror1.text"));
                            this.ipHostError = true;
                            this.badIpAddr = ckIpAddr;
                            this.prepare();
                            return;
                        }
                        ++i;
                    }
                    request.setData("hosts", this.newHosts);
                    this.postTaskletRequest(request);
                }
                if (element.equals("NewButton")) {
                    this.postTaskletRequest(request);
                }
                if (element.equals("DeleteButton")) {
                    if (this.m_iSessionsTableSelection.length <= 0) {
                        try {
                            CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle("cf3270em.noselection.title"), new BaseMessageText("cf3270em.noselection.text"));
                        }
                        catch (HException e) {
                            Trace.trace("XEMU   F", e);
                        }
                    }
                    this.newHosts.remove(this.m_idSessionsTable[this.m_iSessionsTableSelection[0]][0].toString());
                    this.prepare();
                }
                if (element.equals("CancelButton")) {
                    if (!this.newHosts.equals(this.origHosts) && !CommonMsgApp.showDataChangedConfirmation(this.userTaskManager)) {
                        Trace.trace("XEMU   F", "[EmulatorSessionsBean] throw IllegalUserDataException <-- actionPerformed()");
                        throw new IllegalUserDataException();
                    }
                    this.postTaskletRequest(request);
                }
                if (!element.equals("StartButton")) ** GOTO lbl79
                if (this.m_iSessionsTableSelection.length <= 0) {
                    try {
                        CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle("cf3270em.noselection.title"), new BaseMessageText("cf3270em.noselection.text"));
                    }
                    catch (HException e) {
                        Trace.trace("XEMU   F", e);
                    }
                }
                id = this.getSessionsTableRowAt(this.m_iSessionsTableSelection[0]);
                request.setData("ipAddr", id[0].toString());
                this.postTaskletRequest(request);
            }
            catch (IllegalUserDataException e) {
                throw e;
            }
            catch (Exception e) {
                new FrameworkLog(EmulatorSessionsBean.logInfo, 5, e).log();
                this.dispose();
            }
        } else {
            if (this.badRow != this.m_iSessionsTableSelection[0] || this.showMsg) {
                try {
                    CommonMsgApp.showMessageBox(this.userTaskManager, new BaseMessageTitle("cf3270em.hosterror1.title"), new BaseMessageText("cf3270em.hosterror1.text"));
                }
                catch (HException e) {
                    Trace.trace("XEMU   F", e);
                }
            }
            this.showMsg = true;
            this.setSessionsTableSelection(new int[]{this.rowWithError});
        }
lbl79:
        // 12 sources

        Trace.trace("XEMU   T", "[EmulatorSessionsBean] <-- actionPerformed()");
    }
}

